#! /bin/sh
  clear
  VER=0.997
  N=rbldnsd
  NAME=${N}-${VER}
  FN=${NAME}.tar.gz
  set -e

  if [ ! -f ${FN} ];then
  wget  http://www.corpit.ru/mjt/rbldnsd/${FN}
  fi

  if [ -d ${NAME} ];then
    rm -rf ${NAME}
  fi
   
  tar xvfz ${FN}   
  clear

  cd ${NAME}
  touch *
  touch */*
  ./configure
  make

  cp ${N} /usr/sbin/
  cp debian/${N}.init /etc/init.d/${N}
  chmod 755 /etc/init.d/${N}
  cp debian/${N}.default /etc/default/${N}
  echo "Please update /etc/default/${N},  and run /etc/init.d/${N}"

  if ! getent passwd rbldns >/dev/null; then
    adduser --system --group --home /var/lib/rbldns --no-create-home rbldns
    mkdir -p -m0755 /var/lib/rbldns
  fi
   


  nano /etc/default/${N}
